export default defineNuxtPlugin((nuxtApp) => {
  nuxtApp.vueApp.directive('frame-w', {
    mounted: (el, binding) => {
      el.style.width = `${(binding.value / frameWidth.value) * 100}%`
    },
  })

  nuxtApp.vueApp.directive('frame-h', {
    mounted: (el, binding) => {
      el.style.height = `${(binding.value / frameHeight.value) * 100}%`
    },
  })

  nuxtApp.vueApp.directive('frame-x', {
    mounted: (el, binding) => {
      el.style.left = `${(binding.value / frameWidth.value) * 100}%`
    },
  })

  nuxtApp.vueApp.directive('frame-y', {
    mounted: (el, binding) => {
      el.style.top = `${(binding.value / frameHeight.value) * 100}%`
    },
  })

  nuxtApp.vueApp.directive('w', {
    mounted: (el, binding) => {
      const arg = binding.arg ? +binding.arg : undefined
      el.style.width = `${(binding.value / (arg ?? contentWidth.value)) * 100}%`
    },
  })

  nuxtApp.vueApp.directive('h', {
    mounted: (el, binding) => {
      const arg = binding.arg ? +binding.arg : undefined
      el.style.height = `${(binding.value / (arg ?? contentHeight.value)) * 100}%`
    },
  })

  nuxtApp.vueApp.directive('x', {
    mounted: (el, binding) => {
      const arg = binding.arg ? +binding.arg : undefined
      el.style.left = `${(binding.value / (arg ?? contentWidth.value)) * 100}%`
    },
  })

  nuxtApp.vueApp.directive('y', {
    mounted: (el, binding) => {
      const arg = binding.arg ? +binding.arg : undefined
      el.style.top = `${(binding.value / (arg ?? contentHeight.value)) * 100}%`
    },
  })

  nuxtApp.vueApp.directive('frame-wm', {
    mounted: (el, binding) => {
      el.style.width = `${(binding.value / frameWidthMobile.value) * 100}%`
    },
  })

  nuxtApp.vueApp.directive('frame-hm', {
    mounted: (el, binding) => {
      el.style.height = `${(binding.value / frameHeightMobile.value) * 100}%`
    },
  })

  nuxtApp.vueApp.directive('frame-xm', {
    mounted: (el, binding) => {
      el.style.left = `${(binding.value / frameWidthMobile.value) * 100}%`
    },
  })

  nuxtApp.vueApp.directive('frame-ym', {
    mounted: (el, binding) => {
      el.style.top = `${(binding.value / frameHeightMobile.value) * 100}%`
    },
  })

  nuxtApp.vueApp.directive('wm', {
    mounted: (el, binding) => {
      const arg = binding.arg ? +binding.arg : undefined
      el.style.width = `${(binding.value / (arg ?? contentWidthMobile.value)) * 100}%`
    },
  })

  nuxtApp.vueApp.directive('hm', {
    mounted: (el, binding) => {
      const arg = binding.arg ? +binding.arg : undefined
      el.style.height = `${(binding.value / (arg ?? contentHeightMobile.value)) * 100}%`
    },
  })

  nuxtApp.vueApp.directive('hme', {
    mounted: (el, binding) => {
      const arg = binding.arg ? +binding.arg : undefined
      el.style.height = `${(binding.value / (arg ?? extendedContentHeightMobile.value)) * 100}%`
    },
  })

  nuxtApp.vueApp.directive('xm', {
    mounted: (el, binding) => {
      const arg = binding.arg ? +binding.arg : undefined
      el.style.left = `${(binding.value / (arg ?? contentWidthMobile.value)) * 100}%`
    },
  })

  nuxtApp.vueApp.directive('ym', {
    mounted: (el, binding) => {
      const arg = binding.arg ? +binding.arg : undefined
      el.style.top = `${(binding.value / (arg ?? contentHeightMobile.value)) * 100}%`
    },
  })

  nuxtApp.vueApp.directive('yme', {
    mounted: (el, binding) => {
      const arg = binding.arg ? +binding.arg : undefined
      el.style.top = `${(binding.value / (arg ?? extendedContentHeightMobile.value)) * 100}%`
    },
  })
})
